% main_data_plot.m
% 
% plots data
% 
% Estimating Macroeconomic Models of Financial Crises: An Endogenous Regime-Switching Approach*
%   Gianluca Benigno, Andrew Foerster, Christopher Otrok, Alessandro Rebucci
% 
% Updated July 2024
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %

% -- Clear Workspace -- %
clc;
clear;
close all;

% - Data -- %
load bfor_data.mat;
T   = length(dates);

% -- Plot -- %
figure;
subplot(2,1,1)
    hold on;
    bar(dates,rrdates*0.08,1.02,'FaceColor',[0.75 0.75 0.75],'EdgeColor','none','ShowBaseLine','off')
    bar(dates,rrdates*-0.08,1.02,'FaceColor',[0.75 0.75 0.75],'EdgeColor','none','ShowBaseLine','off')
    plot(dates,cay,'-k','LineWidth',2)
    plot(dates,zeros(T,1),'--k')
    xticks(dates(17:20:end))
        ax = gca;
        ax.XMinorTick = 'on';
        datetick('x',17,'keepticks');    %#ok<*DATIC>
        xlim([dates(1) dates(end)]);
        set(gca, 'Layer','top')
    title('Current Account to GDP Ratio')    
    ylim([-0.075 0.05])
    yticks(-0.075:0.025:0.05)
    box on;
subplot(2,1,2)    
    hold on;
    bar(dates,rrdates*0.075,1.02,'FaceColor',[0.75 0.75 0.75],'EdgeColor','none','ShowBaseLine','off')
    bar(dates,rrdates*-0.075,1.02,'FaceColor',[0.75 0.75 0.75],'EdgeColor','none','ShowBaseLine','off')
    plot(dates,ygrow,'-k','LineWidth',2)
    plot(dates,zeros(T,1),'--k')
    xticks(dates(17:20:end))
        ax = gca;
        ax.XMinorTick = 'on';
        datetick('x',17,'keepticks');    
        xlim([dates(1) dates(end)]);
        set(gca, 'Layer','top')
    title('Quarterly GDP Growth Rate')
    ylim([-0.06 0.04])
    yticks(-0.06:0.02:0.06)
    box on
print('-dpdf','../Draft_Figures/Figure_1.pdf','-fillpage')